/*
Half-Life MAP viewing utility.
Copyright (C) 2003  Ryan Samuel Gregg

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "stdafx.h"
#include "AboutForm.h"

CAboutForm::CAboutForm(String *Version, String *Author, String *Date, String *Language, String *Lines)
{
	this->grpAbout = new System::Windows::Forms::GroupBox();

	this->lblVersion = new System::Windows::Forms::Label();
	this->lblAuthor = new System::Windows::Forms::Label();
	this->lblDate = new System::Windows::Forms::Label();
	this->lblLanguage = new System::Windows::Forms::Label();
	this->lblLines = new System::Windows::Forms::Label();

	this->lnkNemsTools = new System::Windows::Forms::LinkLabel();

	this->cmdOK = new System::Windows::Forms::Button();

	// Form Setup
	this->FormBorderStyle = System::Windows::Forms::FormBorderStyle::FixedDialog;
	this->Text = "About MAP Viewer";
	this->AutoScaleBaseSize = System::Drawing::Size(5, 13);
	this->Size = System::Drawing::Size(300, 232);
	this->StartPosition = System::Windows::Forms::FormStartPosition::CenterScreen;
	this->MaximizeBox = false;
	this->MinimizeBox = false;
	this->ShowInTaskbar = false;

	this->Controls->Add(this->grpAbout);
	this->Controls->Add(this->cmdOK);

	// Setup Group
	this->grpAbout->FlatStyle = System::Windows::Forms::FlatStyle::System;
	this->grpAbout->Location = System::Drawing::Point(8, 8);
	this->grpAbout->Size = System::Drawing::Size(280, 152);
	this->grpAbout->TabIndex = 1;
	this->grpAbout->TabStop = false;

	this->grpAbout->Controls->Add(this->lblVersion);
	this->grpAbout->Controls->Add(this->lblAuthor);
	this->grpAbout->Controls->Add(this->lblDate);
	this->grpAbout->Controls->Add(this->lblLanguage);
	this->grpAbout->Controls->Add(this->lblLines);
	this->grpAbout->Controls->Add(this->lnkNemsTools);

	// Version
	this->lblVersion->FlatStyle = System::Windows::Forms::FlatStyle::System;
	this->lblVersion->Location = System::Drawing::Point(90, 36);
	this->lblVersion->Size = System::Drawing::Size(100, 16);
	this->lblVersion->TabIndex = 1;
	this->lblVersion->Text = String::Concat(S"Version: ", Version);

	// Author
	this->lblAuthor->FlatStyle = System::Windows::Forms::FlatStyle::System;
	this->lblAuthor->Location = System::Drawing::Point(90, 52);
	this->lblAuthor->Size = System::Drawing::Size(100, 16);
	this->lblAuthor->TabIndex = 2;
	this->lblAuthor->Text = String::Concat(S"Author: ", Author);

	// Date
	this->lblDate->FlatStyle = System::Windows::Forms::FlatStyle::System;
	this->lblDate->Location = System::Drawing::Point(90, 68);
	this->lblDate->Size = System::Drawing::Size(100, 16);
	this->lblDate->TabIndex = 3;
	this->lblDate->Text = String::Concat(S"Date: ", Date);

	// Language
	this->lblLanguage->FlatStyle = System::Windows::Forms::FlatStyle::System;
	this->lblLanguage->Location = System::Drawing::Point(90, 84);
	this->lblLanguage->Size = System::Drawing::Size(100, 16);
	this->lblLanguage->TabIndex = 4;
	this->lblLanguage->Text = String::Concat(S"Written In: ", Language);

	// Lines
	this->lblLines->FlatStyle = System::Windows::Forms::FlatStyle::System;
	this->lblLines->Location = System::Drawing::Point(90, 100);
	this->lblLines->Size = System::Drawing::Size(100, 16);
	this->lblLines->TabIndex = 5;
	this->lblLines->Text = String::Concat(S"Lines: ", Lines);

	// Link
	this->lnkNemsTools->Location = System::Drawing::Point(200, 128);
	this->lnkNemsTools->Size = System::Drawing::Size(72, 16);
	this->lnkNemsTools->TabIndex = 6;
	this->lnkNemsTools->TabStop = true;
	this->lnkNemsTools->LinkColor = System::Drawing::Color::Black;
	this->lnkNemsTools->VisitedLinkColor = System::Drawing::Color::Black;
	this->lnkNemsTools->Text = "Nem\'s Tools";

	// OK
	this->cmdOK->FlatStyle = System::Windows::Forms::FlatStyle::System;
	this->cmdOK->Location = System::Drawing::Point(112, 168);
	this->cmdOK->TabIndex = 0;
	this->cmdOK->Text = "OK";

	this->add_Closing(new ::CancelEventHandler(this, &CAboutForm::CAboutForm_Closeing));

	this->lnkNemsTools->add_LinkClicked(new ::LinkLabelLinkClickedEventHandler(this, &CAboutForm::lnkNemsTools_LinkClicked));

	this->cmdOK->add_Click(new ::EventHandler(this, &CAboutForm::cmdOK_Click));
}

void CAboutForm::CAboutForm_Closeing(::Object *sender, ::CancelEventArgs *e)
{
	e->Cancel = true;
	this->Hide();
}

void CAboutForm::lnkNemsTools_LinkClicked(::Object *sender, ::LinkLabelLinkClickedEventArgs *e)
{
	System::Diagnostics::Process::Start("IExplore.exe", "http://countermap.counter-strike.net/Nemesis/");
}

void CAboutForm::cmdOK_Click(::Object *sender, ::EventArgs *e)
{
	this->Hide();
}